@extends('layout')

@section('title')
    {{ $title }} - Kang Jual
@endsection

@section('content')
<section class="bg-white dark:bg-gray-900">
    <div class="max-w-screen-xl xl:px-0 px-4 py-16 mx-auto">
        <div class="max-w-screen-md mb-8 lg:mb-16 mx-auto">
            <h2 class="mb-4 text-4xl text-center tracking-tight font-extrabold text-gray-900 dark:text-white">Terms & Conditions</h2>
        </div>
        <div class="dark:text-white">
            <section class="mb-6">
                <h2 class="text-2xl font-semibold mb-2">Effective Date: July 31, 2024</h2>
                <p>Welcome to Kang Jual. By accessing or using our website, you agree to comply with and be bound by the following Terms and Conditions. Please read them carefully.</p>
            </section>
            
            <section class="mb-6">
                <h2 class="text-2xl font-semibold mb-2">1. Acceptance of Terms</h2>
                <p>By using our website and services, you acknowledge that you have read, understood, and agree to these Terms and Conditions. If you do not agree with any part of these terms, you must not use our website.</p>
            </section>
            
            <section class="mb-6">
                <h2 class="text-2xl font-semibold mb-2">2. Services Provided</h2>
                <p>Our website provides a platform for buying and selling source codes. We do not guarantee the accuracy, quality, or completeness of the source codes listed on our site.</p>
            </section>
            
            <section class="mb-6">
                <h2 class="text-2xl font-semibold mb-2">3. User Accounts</h2>
                <p>To use certain features of our website, you may need to create an account. You are responsible for maintaining the confidentiality of your account credentials and for all activities that occur under your account.</p>
            </section>
            
            <section class="mb-6">
                <h2 class="text-2xl font-semibold mb-2">4. Purchases and Payments</h2>
                <ul class="list-disc ml-5">
                    <li><strong>Payment Processing:</strong> Payments for transactions on our website are processed through Midtrans. We do not store your payment details. Midtrans's privacy policy and terms apply to all transactions.</li>
                    <li><strong>Order Confirmation:</strong> After completing a purchase, you will receive a confirmation email with details of your transaction.</li>
                    <li><strong>Download Quota:</strong> Purchased source codes are subject to a download quota as specified during the purchase. Download quotas are tracked and managed in our system.</li>
                </ul>
            </section>
            
            <section class="mb-6">
                <h2 class="text-2xl font-semibold mb-2">5. Content and Intellectual Property</h2>
                <ul class="list-disc ml-5">
                    <li><strong>Ownership:</strong> All content, including source codes, text, graphics, and other materials on our website, are the property of Kang Jual or our content providers and are protected by intellectual property laws.</li>
                    <li><strong>Usage Rights:</strong> You may use purchased source codes only for personal or commercial purposes as specified during the purchase. Redistribution or resale of purchased source codes without authorization is prohibited.</li>
                </ul>
            </section>
            
            <section class="mb-6">
                <h2 class="text-2xl font-semibold mb-2">6. Refunds and Cancellations</h2>
                <ul class="list-disc ml-5">
                    <li><strong>Refund Policy:</strong> Due to the digital nature of our products, we generally do not offer refunds or cancellations once a purchase is completed. Please review your order carefully before finalizing the transaction.</li>
                    <li><strong>Exceptions:</strong> Any exceptions to this policy will be determined at our sole discretion.</li>
                </ul>
            </section>
            
            <section class="mb-6">
                <h2 class="text-2xl font-semibold mb-2">7. Limitation of Liability</h2>
                <ul class="list-disc ml-5">
                    <li><strong>Disclaimer:</strong> Our website and services are provided "as is" without warranties of any kind, either express or implied. We do not warrant that our website will be uninterrupted or error-free.</li>
                    <li><strong>Limitation:</strong> We are not liable for any indirect, incidental, special, or consequential damages arising from the use of our website or services.</li>
                </ul>
            </section>
            
            <section class="mb-6">
                <h2 class="text-2xl font-semibold mb-2">8. Governing Law</h2>
                <p>These Terms and Conditions are governed by and construed in accordance with the laws of Indonesia. Any disputes arising out of or relating to these terms will be subject to the exclusive jurisdiction of the courts in Indonesia.</p>
            </section>
            
            <section class="mb-6">
                <h2 class="text-2xl font-semibold mb-2">9. Changes to Terms</h2>
                <p>We reserve the right to modify or update these Terms and Conditions at any time. Any changes will be posted on this page with the revised effective date. Continued use of our website after any changes constitutes acceptance of the new terms.</p>
            </section>
            
            <section class="mb-6">
                <h2 class="text-2xl font-semibold mb-2">10. Contact Us</h2>
                <p>If you have any questions or concerns regarding these Terms and Conditions, please contact us at:</p>
                <p><strong>Email:</strong> kangjual@kangkoding.com</p>
                <p><strong>WhatsApp:</strong> +625158117703</p>
            </section>
        </div>
    </div>
</section>
@endsection